<?php
// api.php

header("Content-Type: application/json; charset=UTF-8");

// Incluir la conexión a la base de datos
include 'conection/db.php';

// Obtener el método de la solicitud
$method = $_SERVER['REQUEST_METHOD'];

// Obtener el parámetro 'id' si está presente en la URL
// Por ejemplo: api.php?id=1
$id = isset($_GET['id']) ? $_GET['id'] : null;

// Manejar solicitudes OPTIONS para CORS preflight
if ($method == 'OPTIONS') {
    exit(0);
} 

switch ($method) {

    case 'POST':
        handlePOST($pdo);
        break;


    case 'DELETE':
        handleDELETE($pdo, $id);
        break;

    default:
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Metodo no permitido"]);
        break;
}



function handlePOST($pdo) {
    $input = json_decode(file_get_contents("php://input"), true);
    $data = $input ?? null;

    
    try {
        $pdo->beginTransaction();
        // Guardar blogs en usuarios_blogs
        // Guardar blogs en usuarios_blogs
        if (!empty($data['blogs'])) {
            $stmt_check_blogs = $pdo->prepare('SELECT 1 FROM usuarios_blogs WHERE id_blog = ? AND id_usuario = ?');
            $stmt_check_blogs->execute([$data['blogs']['id_blog'], $data['blogs']['id_usuario']]);
            
            if ($stmt_check_blogs->fetch()) {
                // Si existe, lo eliminamos
                $stmt_delete_blogs = $pdo->prepare('DELETE FROM usuarios_blogs WHERE id_blog = ? AND id_usuario = ?');
                $stmt_delete_blogs->execute([$data['blogs']['id_blog'], $data['blogs']['id_usuario']]);
            } else {
                // Si no existe, lo agregamos
                $stmt_blogs = $pdo->prepare('INSERT INTO usuarios_blogs (id_blog, id_usuario) VALUES (?, ?)');
                $stmt_blogs->execute([$data['blogs']['id_blog'], $data['blogs']['id_usuario']]);
            }
        }

        // Guardar videos en usuarios_videos
        if (!empty($data['videos'])) {
            $stmt_check_videos = $pdo->prepare('SELECT 1 FROM usuarios_videos WHERE id_video = ? AND id_usuario = ?');
            $stmt_check_videos->execute([$data['videos']['id_video'], $data['videos']['id_usuario']]);

            if ($stmt_check_videos->fetch()) {
                // Si existe, lo eliminamos
                $stmt_delete_videos = $pdo->prepare('DELETE FROM usuarios_videos WHERE id_video = ? AND id_usuario = ?');
                $stmt_delete_videos->execute([$data['videos']['id_video'], $data['videos']['id_usuario']]);
            } else {
                // Si no existe, lo agregamos
                $stmt_videos = $pdo->prepare('INSERT INTO usuarios_videos (id_video, id_usuario) VALUES (?, ?)');
                $stmt_videos->execute([$data['videos']['id_video'], $data['videos']['id_usuario']]);
            }
        }

        // Guardar descargables en usuarios_descargables
        if (!empty($data['descargables'])) {
            $stmt_check_descargables = $pdo->prepare('SELECT 1 FROM usuarios_descargables WHERE id_descargable = ? AND id_usuario = ?');
            $stmt_check_descargables->execute([$data['descargables']['id_descargable'], $data['descargables']['id_usuario']]);

            if ($stmt_check_descargables->fetch()) {
                // Si existe, lo eliminamos
                $stmt_delete_descargables = $pdo->prepare('DELETE FROM usuarios_descargables WHERE id_descargable = ? AND id_usuario = ?');
                $stmt_delete_descargables->execute([$data['descargables']['id_descargable'], $data['descargables']['id_usuario']]);
            } else {
                // Si no existe, lo agregamos
                $stmt_descargables = $pdo->prepare('INSERT INTO usuarios_descargables (id_descargable, id_usuario) VALUES (?, ?)');
                $stmt_descargables->execute([$data['descargables']['id_descargable'], $data['descargables']['id_usuario']]);
            }
        }

        $pdo->commit();
        echo json_encode(['message' => 'Datos guardados exitosamente']);

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to fetch data']);
    }
}


function handleDELETE($pdo, $id) {
    if (!$id) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "ID no proporcionado"]);
        return;
    }

    try {
        $stmt = $pdo->prepare("DELETE FROM productos WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();

        if ($stmt->rowCount()) {
            echo json_encode(["status" => "success", "message" => "Registro eliminado correctamente"]);
        } else {
            http_response_code(404);
            echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Error al eliminar el registro: " . $e->getMessage()]);
    }
}

?>
