<?php
// api.php

header("Content-Type: application/json; charset=UTF-8");

// Incluir la conexión a la base de datos
include 'conection/db.php';

// Obtener el método de la solicitud
$method = $_SERVER['REQUEST_METHOD'];

// Obtener el parámetro 'id' si está presente en la URL
// Por ejemplo: api.php?id=1
$id = isset($_GET['id']) ? $_GET['id'] : null;

// Manejar solicitudes OPTIONS para CORS preflight
if ($method == 'OPTIONS') {
    exit(0);
} 

switch ($method) {
    case 'GET':
        handleGET($pdo, $id);
        break;

    case 'POST':
        handlePOST($pdo);
        break;

    case 'PUT':
        handlePUT($pdo);
        break;

    case 'DELETE':
        handleDELETE($pdo, $id);
        break;

    default:
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Metodo no permitido"]);
        break;
}


function handleGET($pdo, $id) {
  try {
    try {
        // Consultas a las diferentes tablas
        $stmt_home = $pdo->query('SELECT * FROM secciones');
        $home = $stmt_home->fetchAll(PDO::FETCH_ASSOC);

        $stmt_media = $pdo->query('SELECT * FROM media_secciones');
        $media_secciones = $stmt_media->fetchAll(PDO::FETCH_ASSOC);

        $stmt_productos = $pdo->query('SELECT * FROM productosdestacados_secciones');
        $productosDestacados = $stmt_productos->fetchAll(PDO::FETCH_ASSOC);

        $stmt_secciones = $pdo->query('SELECT * FROM secciones_secciones');
        $secciones_secciones = $stmt_secciones->fetchAll(PDO::FETCH_ASSOC);

        $stmt_tiktok = $pdo->query('SELECT * FROM tiktok_secciones');
        $tiktok_secciones = $stmt_tiktok->fetchAll(PDO::FETCH_ASSOC);

        // Enviar los datos en formato JSON
        echo json_encode([
            'home' => $home,
            'media_secciones' => $media_secciones,
            'productosDestacados' => $productosDestacados,
            'secciones_secciones' => $secciones_secciones,
            'tiktok_secciones' => $tiktok_secciones
        ]);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al obtener los datos: ' . $e->getMessage()]);
    }
  } catch (PDOException $e) {
      http_response_code(500);
      echo json_encode(["status" => "error", "message" => "Error al obtener los datos: " . $e->getMessage()]);
  }
}

function handlePOST($pdo) {
    $input = json_decode(file_get_contents('php://input'), true);

    if (!isset($input['campo1']) || !isset($input['campo2'])) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "Datos incompletos"]);
        return;
    }

    $campo1 = $input['campo1'];
    $campo2 = $input['campo2'];

    try {
        // Insertar un nuevo registro
        $stmt = $pdo->prepare("INSERT INTO productos (campo1, campo2) VALUES (:campo1, :campo2)");
        $stmt->bindParam(':campo1', $campo1);
        $stmt->bindParam(':campo2', $campo2);
        $stmt->execute();

        $id = $pdo->lastInsertId();

        echo json_encode(["status" => "success", "message" => "Registro creado correctamente", "id" => $id]);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Error al crear el registro: " . $e->getMessage()]);
    }
}
function handlePUT($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);

    try {
        $sql = "UPDATE secciones SET
            videoPrincipal = :videoPrincipal,
            pathVideoPrincipal = :pathVideoPrincipal,
            twitter = :twitter,
            tiktok = :tiktok,
            facebook = :facebook,
            pinterest = :pinterest,
            instagram = :instagram,
            path_url_catalogo = :path_url_catalogo,
            url_catalogo = :url_catalogo,
            conocenosLink = :conocenosLink,
            paht_conocenosLink = :paht_conocenosLink
        WHERE id = :id";
        
        $stmt = $pdo->prepare($sql);

        $stmt->execute([
            ':id' => "Home",
            ':videoPrincipal' => $data['videoPrincipal'],
            ':pathVideoPrincipal' => $data['pathVideoPrincipal'],
            ':twitter' => $data['twitter'],
            ':tiktok' => $data['tiktok'],
            ':facebook' => $data['facebook'],
            ':pinterest' => $data['pinterest'],
            ':instagram' => $data['instagram'],
            ':path_url_catalogo' => $data['path_url_catalogo'],
            ':url_catalogo' => $data['url_catalogo'],
            ':conocenosLink' => $data['conocenosLink'],
            ':paht_conocenosLink' => $data['paht_conocenosLink']
        ]);

        // Actualización de tiktok_secciones
        if (!empty($data['tiktok_secciones'])) {
            foreach ($data['tiktok_secciones'] as $tiktok) {
                $sqltiktok = "UPDATE tiktok_secciones SET
                    imagen = :imagen,
                    path_imagen = :path_imagen,
                    orden = :orden,
                    seccion_id = :seccion_id,
                    url = :url
                WHERE id = :id";

                $stmTiktok = $pdo->prepare($sqltiktok);

                $stmTiktok->execute([
                    ':id' => $tiktok['id'],
                    ':imagen' => $tiktok['imagen'],
                    ':path_imagen' => $tiktok['path_imagen'],
                    ':orden' => $tiktok['orden'],
                    ':seccion_id' => $tiktok['seccion_id'],
                    ':url' => $tiktok['url']
                ]);
            }
        }

        // Actualización de secciones_secciones
        if (!empty($data['secciones'])) {
            foreach ($data['secciones'] as $seccion) {
                $sqlSecciones = "UPDATE secciones_secciones SET
                    imagen = :imagen,
                    path_imagen = :path_imagen,
                    orden = :orden,
                    color = :color,
                    seccion_id = :seccion_id,
                    slug = :slug,
                    titulo = :titulo
                WHERE id = :id";

                $stmSecciones = $pdo->prepare($sqlSecciones);

                $stmSecciones->execute([
                    ':id' => $seccion['id'],
                    ':imagen' => $seccion['imagen'],
                    ':path_imagen' => $seccion['path_imagen'],
                    ':orden' => $seccion['orden'],
                    ':seccion_id' => $seccion['seccion_id'],
                    ':color' => $seccion['color'],
                    ':slug' => $seccion['slug'],
                    ':titulo' => $seccion['titulo']
                ]);
            }
        }

        // Actualización de productosdestacados_secciones
        if (!empty($data['productosDestacados'])) {
            foreach ($data['productosDestacados'] as $producto) {
                $sqlProducto = "UPDATE productosdestacados_secciones SET
                    imagen = :imagen,
                    path_imagen = :path_imagen,
                    seccion_id = :seccion_id
                WHERE id = :id";

                $stmProductos = $pdo->prepare($sqlProducto);

                $stmProductos->execute([
                    ':id' => $producto['id'],
                    ':imagen' => $producto['imagen'],
                    ':path_imagen' => $producto['path_imagen'],
                    ':seccion_id' => $producto['seccion_id']
                ]);
            }
        }

        // Actualización de media_secciones
        /*if (!empty($data['medias'])) {
            foreach ($data['medias'] as $media) {
                $sqlMedia = "UPDATE media_secciones SET
                    imagen = :imagen,
                    path_imagen = :path_imagen,
                    orden = :orden,
                    seccion_id = :seccion_id
                WHERE id = :id";

                $stmMedia = $pdo->prepare($sqlMedia);

                $stmMedia->execute([
                    ':id' => $media['id'],
                    ':imagen' => $media['imagen'],
                    ':path_imagen' => $media['path_imagen'],
                    ':orden' => $media['orden'],
                    ':seccion_id' => $media['seccion_id']
                ]);
            }
        }*/

        echo json_encode(["status" => "success", "message" => "Registro actualizado correctamente"]);


    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Error al actualizar el registro: " . $e->getMessage()]);
    }
}

function handleDELETE($pdo, $id) {
    if (!$id) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "ID no proporcionado"]);
        return;
    }

    try {
        $stmt = $pdo->prepare("DELETE FROM productos WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();

        if ($stmt->rowCount()) {
            echo json_encode(["status" => "success", "message" => "Registro eliminado correctamente"]);
        } else {
            http_response_code(404);
            echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Error al eliminar el registro: " . $e->getMessage()]);
    }
}
?>
