<?php


header("Content-Type: application/json; charset=UTF-8");

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Incluir la conexión a la base de datos
include 'conection/db.php';

// Ruta para guardar las imágenes
// Ruta base para guardar las imágenes
$uploadDir = __DIR__ . '/images/';

function handleImageUpload($pdo, $uploadDir) {
    // Verificar si el método de la solicitud es POST
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Metodo no permitido"]);
        exit();
    }

    // Verificar si se ha enviado un archivo
    if (!isset($_FILES['image']) || $_FILES['image']['error'] !== UPLOAD_ERR_OK) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "No se ha enviado una imagen válida"]);
        exit();
    }

    // Verificar si se ha enviado el path
    $path = isset($_POST['path']) ? $_POST['path'] : '';

    if (empty($path)) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "Path no proporcionado"]);
        exit();
    }

    // Obtener los detalles del archivo
    $file = $_FILES['image'];
    $fileName = basename($file['name']);
    $fileTmpName = $file['tmp_name'];
    $fileSize = $file['size'];
   /* $fileType = mime_content_type($fileTmpName);

    // Verificar el tipo de archivo (solo imágenes)
    $allowedTypes = ['image/jpeg', 'image/png', 'application/pdf', 'video/mp4', 'video/webm'];
    
    if (!in_array($fileType, $allowedTypes)) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "Formato de imagen no permitido"]);
        exit();
    }*/

    // Generar un nombre de archivo único
    $newFileName = uniqid('', true) . "." . pathinfo($fileName, PATHINFO_EXTENSION);

    // Definir la ruta completa
    $uploadPath = $uploadDir . $path . '/' . $newFileName;

    if (move_uploaded_file($fileTmpName, $uploadPath)) {
      echo json_encode(["status" => "success", "message" => "Imagen subida exitosamente", "filename" => $newFileName]);
    } else {
      http_response_code(500);
      echo json_encode(["status" => "error", "message" => "Error al subir la imagen"]);
    }
}

handleImageUpload($pdo, $uploadDir);

?>