<?php
// api.php

header("Content-Type: application/json; charset=UTF-8");

// Incluir la conexión a la base de datos
include 'conection/db.php';

// Obtener el método de la solicitud
$method = $_SERVER['REQUEST_METHOD'];

// Obtener el parámetro 'id' si está presente en la URL
// Por ejemplo: api.php?id=1
$id = isset($_GET['id']) ? $_GET['id'] : null;

// Manejar solicitudes OPTIONS para CORS preflight
if ($method == 'OPTIONS') {
    exit(0);
} 

switch ($method) {
    case 'GET':
        handleGET($pdo, $id);
        break;

    case 'PUT':
        handlePUT($pdo);
        break;

    default:
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Metodo no permitido"]);
        break;
}


function handleGET($pdo, $id) {
  try {
        // Consultas SQL
        $stmt_nosotros = $pdo->query('SELECT * FROM secciones_nosotros');
        $nosotros = $stmt_nosotros->fetchAll(PDO::FETCH_ASSOC);

        $stmt_distribuidores = $pdo->query('SELECT * FROM distribuidores_nosotros');
        $distribuidores = $stmt_distribuidores->fetchAll(PDO::FETCH_ASSOC);

        // Respuesta en formato JSON
        echo json_encode([
            'nosotros' => $nosotros,
            'distribuidores' => $distribuidores
        ]);
  } catch (PDOException $e) {
      http_response_code(500);
      echo json_encode(["status" => "error", "message" => "Error al obtener los datos: " . $e->getMessage()]);
  }
}


function handlePUT($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);


    try {
         $sql = "UPDATE secciones_nosotros SET
                subtitulo = :subtitulo,
                pathImagen = :pathImagen,
                titulo=:titulo,
                descripcion_breve=:descripcion_breve,
                imagen = :imagen,
                email = :email,
                direccion = :direccion,
                telefono =:telefono,
                email_contacto = :email_contacto
            WHERE id = :id";
        
        $stmt = $pdo->prepare($sql);

        $stmt->execute([
            ':id' => "Nosotros",
            ':subtitulo' => $data['subtitulo'],
            ':pathImagen' => $data['pathImagen'],
            ':titulo' => $data['titulo'],
            ':descripcion_breve' => $data['descripcion_breve'],
            ':imagen' => $data['imagen'],
            ':email' => $data['email'],
            ':direccion' => $data['direccion'],
            ':telefono' => $data['telefono'],
            ':email_contacto' => $data['email_contacto']
        ]);



        if (!empty($data['distribuidores']["imagenes"])) {
                foreach ($data['distribuidores']["imagenes"]as $key => $distribuidor) {
                    $sqlDistribuidor = "UPDATE distribuidores_nosotros SET
                    imagen = :imagen,
                    path_imagen = :path_imagen,
                    url = :url
                WHERE id = :id";

                $stmtDistribuidor = $pdo->prepare($sqlDistribuidor);

                $stmtDistribuidor->execute([
                    ':id' => $distribuidor['id'],
                    ':imagen' => $distribuidor['imagen'],
                    ':path_imagen' => $distribuidor['path_imagen'],
                    ':url' => $distribuidor['url']
                ]);
            }
        }

        if ($stmt->rowCount()) {
            echo json_encode(["status" => "success", "message" => "Registro actualizado correctamente"]);
        } else {
            http_response_code(404);
            echo json_encode(["status" => "error", "message" => "Registro no encontrado o sin cambios"]);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Error al actualizar el registro: " . $e->getMessage()]);
    }
}


?>
