<?php

include '../conection/database.php';

$database = new Database();
$db = $database->getConnection();
$id = isset($_GET['id']) ? intval($_GET['id']) : null;
$sku = isset($_GET['sku']) ? $_GET['sku'] : null;

if ($id === null && $sku === null) {
    http_response_code(400);
    echo json_encode(["success" => false, "message" => "ID de producto no proporcionado."]);
    exit;
}

try {
    // Obtener datos de la producto dependiendo del id o sku
    if ($id) {
        $query = $db->prepare("SELECT * FROM productos_catalogo WHERE id = :id");
        $query->bindParam(':id', $id, PDO::PARAM_INT);
        $query->execute();
    } else if ($sku) {
        $query = $db->prepare("SELECT * FROM productos_catalogo WHERE sku = :sku");
        $query->bindParam(':sku', $sku, PDO::PARAM_STR);
        $query->execute();
    }


    $producto = $query->fetch(PDO::FETCH_ASSOC);

    if (!$producto) {
        http_response_code(404);
        echo json_encode(["success" => false, "message" => "Producto no encontrado."]);
        exit;
    }

    // Obtener imagenes del producto
    $producto_id = $producto['id'];
    $query = $db->prepare("SELECT * FROM productos_imagenes WHERE producto_id = :producto_id");
    $query->bindParam(':producto_id', $producto_id, PDO::PARAM_INT);
    $query->execute();
    $imagenes = $query->fetchAll(PDO::FETCH_ASSOC);

    // Obtener productos_imagenes_pequenas del producto
    $query = $db->prepare("SELECT * FROM productos_imagenes_pequenas WHERE producto_id = :producto_id");
    $query->bindParam(':producto_id', $producto_id, PDO::PARAM_INT);
    $query->execute();
    $imagenes_pequenas = $query->fetchAll(PDO::FETCH_ASSOC);

    // Combinar datos
    $producto['imagenes'] = $imagenes;
    $producto['imagenes_pequenas'] = $imagenes_pequenas;

    echo json_encode(["success" => true, "data" => $producto]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Error en el servidor: " . $e->getMessage()]);
}
