<?php

header('Content-Type: application/json');

include 'conection/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $json = file_get_contents('php://input');
    $data = json_decode($json);

    $email = $data->email ?? '';

    if (!empty($email)) {
        try {
            // Obtener un solo registro
            $stmt = $pdo->prepare("SELECT password FROM usuarios WHERE email = :email");
            $stmt->bindParam(':email', $email, PDO::PARAM_STR);
            $stmt->execute();
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($user && isset($user['password'])) {
                $encryptedPassword = $user['password'];
                $decryptedPassword = decrypt($encryptedPassword, 3);

                // Responder con el password desencriptado
                echo json_encode([
                    "status" => "success",
                    "password" => $decryptedPassword
                ]);
            } else {
                // Si no se encuentra el usuario o no tiene contraseña
                echo json_encode([
                    "status" => "error",
                    "message" => "Usuario no encontrado o sin contraseña."
                ]);
            }
        } catch (Exception $e) {
            echo json_encode([
                "status" => "error",
                "message" => "Error al obtener los datos: " . $e->getMessage()
            ]);
        }
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "El email no puede estar vacío."
        ]);
    }
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Método no permitido."
    ]);
}

function decrypt($string, $shift) {
    $result = '';
    for ($i = 0; $i < strlen($string); $i++) {
        $result .= chr(ord($string[$i]) - $shift);
    }
    return $result;
}

?>
