<?php
// api.php

header("Content-Type: application/json; charset=UTF-8");

// Incluir la conexión a la base de datos
include 'conection/db.php';

// Obtener el método de la solicitud
$method = $_SERVER['REQUEST_METHOD'];

$id = isset($_GET['id']) ? $_GET['id'] : null;


// Manejar solicitudes OPTIONS para CORS preflight
if ($method == 'OPTIONS') {
    exit(0);
} 

switch ($method) {
    case 'GET':
        handleGET($pdo, $id);
        break;


    case 'PUT':
        handlePUT($pdo);
        break;

    case 'DELETE':
        handleDELETE($pdo);
        break;

    default:
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Metodo no permitido"]);
        break;
}


function handleGET($pdo, $id) {
  try {
    if ($id) {
        // Obtener un solo registro
        $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_STR);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($data) {
          echo json_encode([
              'usuarios' => $data,
          ]);
        } else {
            http_response_code(404);
            echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
        }
    } else {
        // Obtener todos los registros
        $stmt = $pdo->prepare("SELECT * FROM usuarios");
        $stmt->execute();
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $data = array_map('convertBooleans', $data);
        echo json_encode(['usuarios' => $data]);
    }
  } catch (PDOException $e) {
      http_response_code(500);
      echo json_encode(["status" => "error", "message" => "Error al obtener los datos: " . $e->getMessage()]);
  }
}

function handlePUT($pdo) {

    $input = json_decode(file_get_contents('php://input'), true);
    $id = $input['id'] ?? null;

    if (!$id) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "ID no proporcionado"]);
        return;
    }

    try {
        $sql = "UPDATE usuarios SET
            nombre = :nombre,
            email = :email,
            password = :password,
            rol = :rol
        WHERE id = :id";
        
        $stmt = $pdo->prepare($sql);

        $stmt->execute([
            ':id' => $id,
            ':nombre' => $input['nombre'],
            ':email' => $input['email'],
            ':password' => $input['password'],
            ':rol' => $input['rol']
        ]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['id' => $id, 'message' => 'Actualizado con éxito']);
        } else {
            http_response_code(404);
            echo json_encode(['message' => 'No se encontró el registro para actualizar']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Error al actualizar el registro: " . $e->getMessage()]);
    }
}

function handleDELETE($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    $id = $data['id'] ?? null;

    if (!$id) {
        http_response_code(400);
        echo json_encode(['error' => 'Se requiere un ID para eliminar el registro']);
        return;
    }

    try {
        // Preparar la consulta de eliminación
        $sql = "DELETE FROM usuarios WHERE id = :id";
        $stmt = $pdo->prepare($sql);

        // Ejecutar la consulta con el ID proporcionado
        $stmt->execute([':id' => $id]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['message' => 'Registro eliminado con éxito']);
        } else {
            http_response_code(404);
            echo json_encode(['message' => 'Registro no encontrado']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error en el servidor: ' . $e->getMessage()]);
    }
}

function convertBooleans($item) {
    foreach ($item as $key => $value) {
        if ($value === '1' || $value === 1) {
            $item[$key] = true;
        } elseif ($value === '0' || $value === 0) {
            $item[$key] = false;
        }
    }
    return $item;
}
?>
