<?php
// api.php

header("Content-Type: application/json; charset=UTF-8");

// Incluir la conexión a la base de datos
include 'conection/db.php';

// Obtener el método de la solicitud
$method = $_SERVER['REQUEST_METHOD'];

// Obtener el parámetro 'id' si está presente en la URL
// Por ejemplo: api.php?id=1
$id = isset($_GET['id']) ? $_GET['id'] : null;
$id_video = isset($_GET['id_video']) ? $_GET['id_video'] : null;


// Manejar solicitudes OPTIONS para CORS preflight
if ($method == 'OPTIONS') {
    exit(0);
} 

switch ($method) {
    case 'GET':
        handleGET($pdo, $id, $id_video);
        break;

    case 'POST':
        handlePOST($pdo);
        break;

    case 'PUT':
        handlePUT($pdo);
        break;

    case 'DELETE':
        handleDELETE($pdo);
        break;

    default:
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Metodo no permitido"]);
        break;
}


function handleGET($pdo, $id, $id_video) {
  try {
      if ($id) {
          // Obtener un solo registro
          $stmt = $pdo->prepare("SELECT * FROM video WHERE slug = :slug");
          $stmt->bindParam(':slug', $id, PDO::PARAM_STR);
          $stmt->execute();
          $data = $stmt->fetch(PDO::FETCH_ASSOC);
          $data = array_map('convertBooleans', [$data]);

          if ($data) {
            echo json_encode(['videos' => $data]);
          } else {
              http_response_code(404);
              echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
          }
          
      } else if ($id_video) {
        // Obtener un solo registro
        $stmt = $pdo->prepare("SELECT * FROM video WHERE id = :id");
        $stmt->bindParam(':id', $id_video, PDO::PARAM_STR);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        $data = array_map('convertBooleans', [$data]);

        if ($data) {
          echo json_encode(['videos' => $data]);
        } else {
            http_response_code(404);
            echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
        }
    } else {
          // Obtener todos los registros
          $stmt = $pdo->prepare("SELECT * FROM video");
          $stmt->execute();
          $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
          $data = array_map('convertBooleans', $data);
          echo json_encode(['videos' => $data]);

      }
  } catch (PDOException $e) {
      http_response_code(500);
      echo json_encode(["status" => "error", "message" => "Error al obtener los datos: " . $e->getMessage()]);
  }
}


function handlePOST($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    $incremento = $data['incremento'] ?? null;
    $tipo = $data['tipo'] ?? null;
    $id = $data['id'] ?? null;

    if (!$id) {
        http_response_code(400);
        echo json_encode(['error' => 'Faltan parametros en la solicitud']);
        return;
    }

    try {
        if($incremento !== null){
            $query = $tipo === "likes"
            ? 'UPDATE video SET likes = ? WHERE id = ?'
            : 'UPDATE video SET favoritos = ? WHERE id = ?';

            $stmt = $pdo->prepare($query);
            $stmt->execute([$incremento, $id]);

            if ($stmt->rowCount() === 0) {
                http_response_code(404);
                echo json_encode(['message' => 'Registro no encontrado']);
                return;
            }
            echo json_encode(['message' => 'Valor incrementado con exito']);
        }
        else{
        
            $sql = "INSERT INTO video (
                id,
                contenido,
                img_destacada, 
                fechaRegistro, 
                categorias, 
                titulo, 
                img_thumb, 
                descripcion_breve, 
                slug,
                url_vimeo,
                destacado,
                activo, 
                path_img_destacada,
                restringido,
                path_img_thumb, 
                likes,
                edad, 
                video_contenido, 
                favoritos, 
                path_video_contenido,
                img_contenido,
                img_portada
            ) VALUES (
                :id,
                :contenido, 
                :img_destacada,
                :fechaRegistro, 
                :categorias, 
                :titulo, 
                :img_thumb, 
                :descripcion_breve, 
                :slug,
                :url_vimeo,
                :destacado,
                :activo, 
                :path_img_destacada,
                :restringido,
                :path_img_thumb, 
                :likes,
                :edad, 
                :video_contenido, 
                :favoritos, 
                :path_video_contenido,
                :img_contenido,
                :img_portada
            )";
    
            // Preparar la consulta
            $stmt = $pdo->prepare($sql);
    
            $stmt->execute([
                ':id' => $id,
                ':contenido' => $data['contenido'],
                ':img_destacada' => $data['img_destacada'],
                ':fechaRegistro' => $data['fechaRegistro'],
                ':categorias' => $data['categorias'],
                ':titulo' => $data['titulo'],
                ':img_thumb' => $data['img_thumb'],
                ':descripcion_breve' => $data['descripcion_breve'],
                ':slug' => $data['slug'],
                ':url_vimeo' => $data['url_vimeo'],
                ':destacado' => $data['destacado'],
                ':activo' => $data['activo'],
                ':path_img_destacada' => $data['path_img_destacada'],
                ':restringido' => $data['restringido'],
                ':path_img_thumb' => $data['path_img_thumb'],
                ':likes' => $data['likes'],
                ':edad' => $data['edad'],
                ':video_contenido' => $data['video_contenido'],
                ':favoritos' => $data['favoritos'],
                ':path_video_contenido' => $data['path_video_contenido'],
                ':img_contenido' => $data['img_contenido'],
                ':img_portada' => $data['img_portada']
             ]);
    
            // Retornar un mensaje de éxito
            echo json_encode(['id' => $data['id']]);
        }
    
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error en el servidor']);
    }
}

function handlePUT($pdo) {
    $input = json_decode(file_get_contents('php://input'), true);
    if (!is_array($input)) {
        http_response_code(400);
        echo json_encode(['error' => 'Datos de entrada inválidos']);
        return;
    }

    // Obtener el ID del registro a actualizar
    $id = $input['id'] ?? null;

    if (!$id) {
        http_response_code(400);
        echo json_encode(['error' => 'Falta el parámetro "id" en la solicitud']);
        return;
    }

    try {
        $sql = "UPDATE video SET
            contenido = :contenido,
            path_img_destacada = :path_img_destacada,
            fechaRegistro = :fechaRegistro,
            categorias = :categorias,
            titulo = :titulo,
            img_thumb = :img_thumb,
            descripcion_breve = :descripcion_breve,
            slug = :slug,
            url_vimeo = :url_vimeo,
            destacado = :destacado,
            activo = :activo,
            restringido = :restringido,
            path_img_thumb = :path_img_thumb,
            likes = :likes,
            edad = :edad,
            video_contenido = :video_contenido,
            favoritos = :favoritos,
            path_video_contenido = :path_video_contenido,
            img_contenido = :img_contenido,
            img_portada = :img_portada
        WHERE id = :id";

        $stmt = $pdo->prepare($sql);

        // Ejecutar la consulta con los parámetros proporcionados
        $stmt->execute([
            ':id' => $id,
            ':contenido' => $input['contenido'] ?? null,
            ':path_img_destacada' => $input['path_img_destacada'] ?? null,
            ':fechaRegistro' => $input['fechaRegistro'] ?? null,
            ':categorias' => $input['categorias'] ?? null,
            ':titulo' => $input['titulo'] ?? null,
            ':img_thumb' => $input['img_thumb'] ?? null,
            ':descripcion_breve' => $input['descripcion_breve'] ?? null,
            ':slug' => $input['slug'] ?? null,
            ':url_vimeo' => $input['url_vimeo'] ?? null,
            ':destacado' => $input['destacado'] ?? null,
            ':activo' => $input['activo'] ?? null,
            ':restringido' => $input['restringido'] ?? null,
            ':path_img_thumb' => $input['path_img_thumb'] ?? null,
            ':likes' => $input['likes'] ?? null,
            ':edad' => $input['edad'] ?? null,
            ':video_contenido' => $input['video_contenido'] ?? null,
            ':favoritos' => $input['favoritos'] ?? null,
            ':path_video_contenido' => $input['path_video_contenido'] ?? null,
            ':img_contenido' => $input['img_contenido'] ?? null,
            ':img_portada' => $input['img_portada'] ?? null
        ]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['id' => $id, 'message' => 'Actualizado con éxito']);
        } else {
            // Verificar si el registro no existe
            // Opcional: Puedes realizar una consulta para verificar si el ID existe
            http_response_code(404);
            echo json_encode(['message' => 'No se encontró el registro para actualizar']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        // Para producción, evita exponer detalles de errores. Solo para desarrollo:
        echo json_encode(["status" => "error", "message" => "Error al actualizar el registro: " . $e->getMessage()]);
    }
}

function handleDELETE($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    $id = $data['id'] ?? null;
    $activo = false;

    if (!$id) {
        http_response_code(400);
        echo json_encode(['error' => 'Se requiere un ID para eliminar el registro']);
        return;
    }

    try {
        if ($id) {
            $sql = "UPDATE video SET
                activo = :activo
            WHERE id = :id";
        
        $stmt = $pdo->prepare($sql);

        $stmt->execute([
            ':id' => $id,
            ':activo' => $activo,
        ]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['id' => $id, 'message' => 'Eliminado con exito']);
        } else {
            http_response_code(404);
            echo json_encode(['message' => 'No se encontro el registro para actualizar']);
        }
    }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error en el servidor: ' . $e->getMessage()]);
    }
}

function convertBooleans($item) {
    foreach ($item as $key => $value) {
        if ($value === '1' || $value === 1) {
            $item[$key] = true;
        } elseif ($value === '0' || $value === 0) {
            $item[$key] = false;
        }
    }
    return $item;
}
?>
